#include<cstdio>
#include<cstring>
#include<algorithm>
#include<iostream>
#include<cmath>
#include<set>
#include<vector>
#include<random>
using namespace std;
const int N = 4336;
const int dim = 2;
const double eta = 0.018;
double dis[N + 1];
double cost = 0;
vector<int> Fset;
struct demand {
	double x[dim + 1];
	double c, r;
	int t;
}D[N + 1], P[N + 1];
default_random_engine e;
uniform_real_distribution<double> u(-eta, eta); // generate error 

inline double dist(demand &d1, demand &d2) {
	double ret = 0;
	for (int i = 1; i <= dim; i++)
		ret += (d1.x[i] - d2.x[i]) * (d1.x[i] - d2.x[i]);
	return sqrt(ret);
}

bool cmp(demand a, demand b) {
	return a.r < b.r;
}


int main() {
	freopen("nonuniform.txt", "r", stdin);
	for (int i = 1; i <= N; i++) {
		for (int j = 1; j <= dim; j++)
			scanf("%lf", &D[i].x[j]);
		scanf("%lf", &D[i].c);
		D[i].t = i;
	}
	for (int i = 1; i <= N; i++) {
		if (i % 2000 == 0) 
			printf("%d\n", i);
		for (int j = 1; j <= N; j++)
			dis[j] = dist(D[i], D[j]);
		sort(dis + 1, dis + N + 1); 
		double total = 0;
		double r = 0;
		for (int j = 1; j <= N; j++) {
			total += dis[j];
			r = (total + D[i].c) / j;
			if ((r <= dis[j + 1]  && r >= dis[j]) || j == N) {
				D[i].r = r;   
				break;
			}
		}
	}
	sort(D + 1, D + N + 1, cmp);
	for (int i = 1; i <= N; i++) {
		int siz = Fset.size();
		bool flag = 0;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			if (dist(D[pos], D[i]) <= 2 * D[i].r) {
				flag = 1;
				break;
			}
		}
		if (!flag) {
			Fset.push_back(i);
			cost += D[i].c;
		}
	}
	freopen("nonuniform_predict.txt", "w", stdout);
	for (int i = 1; i <= N; i++) {
		P[i] = D[i];
		for (int j = 1; j <= N; j++) {
			double d = dist(D[i], D[j]);

			if (d <= eta && P[i].c <= D[j].c) {  // choose the maximal opening cost facility as prediction
				P[i] = D[j];  
			}
		}
	}
	for (int i = 1; i <= N; i++) {
		int siz = Fset.size();
		double connect_cost = 1e9;
		demand opt;
		for (int j = 0; j < siz; j++) {
			int pos = Fset[j];
			double dis = dist(D[pos], D[i]);
			if (connect_cost > dis) {
				connect_cost = dis;
				for (int k = 1; k <= dim; k++)
					opt.x[k] = P[pos].x[k];
				opt.c = P[pos].c;
			}
		}
		cost += connect_cost;
		printf("%d %.6lf", D[i].t, opt.c);
		for (int j = 1; j <= dim; j++)
			printf(" %.6lf", opt.x[j]);
		puts("");
	}
	printf("%.6f\n", cost);
	printf("%lu\n", Fset.size());
}